import os, json, hashlib
import numpy as np

def _sha256_bytes(b: bytes) -> str:
    import hashlib
    return hashlib.sha256(b).hexdigest()

def load_e0(e0_path, L):
    arr = None
    try:
        with np.load(e0_path) as z:
            if "E0" in z:
                arr = z["E0"]
            else:
                keys = list(z.keys())
                if keys:
                    arr = z[keys[0]]
    except Exception:
        return None, None
    if arr is None or arr.shape != (L, L):
        return None, None
    h = _sha256_bytes(arr.tobytes())
    return arr.astype(np.float64, copy=False), h

def find_kernel_path(data_dir, gauge, L):
    cand_np = os.path.join(data_dir, "kernels", gauge, f"kernel_L{L}.npy")
    cand_nz = os.path.join(data_dir, "kernels", gauge, f"kernel_L{L}.npz")
    if os.path.exists(cand_np): return cand_np
    if os.path.exists(cand_nz): return cand_nz
    return None

def load_kernel_info(kernel_path):
    # Only for provenance; not required for computation.
    if kernel_path is None or (not os.path.exists(kernel_path)):
        return None, None, None
    try:
        if kernel_path.endswith(".npy"):
            arr = np.load(kernel_path, allow_pickle=False)
        else:
            with np.load(kernel_path) as z:
                arr = z[list(z.keys())[0]]
        h = hashlib.sha256(arr.tobytes()).hexdigest()
        shape = tuple(arr.shape)
        return shape, str(arr.dtype), h
    except Exception:
        return None, None, None

def ensure_outdir(p):
    os.makedirs(os.path.dirname(p), exist_ok=True)
